### **实验名称**

Python 编程操作 MongoDB

### **实验目的**

1、掌握 Python 操作 MongoDB

2、掌握 MongoDB 查询常用方法

### **实验背景**

MongoDB 是由 C++ 语言编写的非关系型数据库，是一个基于分布式文件存储的开源数据库系统，其内容存储形式类似 JSON 对象，它的字段值可以包含其他文档、数组及文档数组，非常灵活。

MongoDB 是一个介于关系数据库和非关系数据库之间的产品，是非关系数据库当中功能最丰富，最像关系数据库的。

### **实验原理**

pymongo 是 Python 访问 MongoDB 的模块，该模块定义了一个操作 MongoDB 的类 MongoClient，包含了连接管理、集合管理、索引管理、增删改查、文件操作、聚合操作等方法。

### **实验环境**

Ubuntu18.04

Python3.8

MongoDB6.0.8

### **建议课时**

1课时

### **实验步骤**

一、环境搭建

1. 启动 mongod 服务

   （1）在指定目录下创建 mongodb 文件夹、其子文件夹 data、log 以及文件 mongodb.log

   ```sh
   cd /home/ubuntu
   mkdir -p mongodb/data
   mkdir -p mongodb/log
   touch mongodb/log/mongodb.log
   ```

   （2）执行 mongod 命令以启动 mongod 服务

   ```sh
   mongod --dbpath /home/ubuntu/mongodb/data --logpath /home/ubuntu/mongodb/log/mongodb.log --logappend --fork # 启动 mongod 服务
   ```

2. 安装 pymongo 依赖

   在终端 Terminal 中输入以下命令进行安装

   ```sh
   pip3 install pymongo==4.1.1 # 如果当前环境是 Python3 环境，则使用 pip 关键字
   ```

   ![11-1.5-1-安装依赖.png](./pic/11-1.5-1-安装依赖.png)

二、编写 Python 程序

1. 在 `/home/ubuntu` 目录下创建 Python 文件，命名为 pybbs.py

   ![11-1.5-2-新建pybbs-1.png](./pic/11-1.5-2-新建pybbs-1.png)

   ![11-1.5-2-新建pybbs-2.png](./pic/11-1.5-2-新建pybbs-2.png)

2. 在 pybbs.py 中编写如下代码

   ```python
   from pymongo import MongoClient
   from random import randint
   
   name = [
       'yangx',
       'yxxx',
       'laok',
       'kkk',
       'ji',
       'gaoxiao',
       'laoj',
       'meimei',
       'jj',
       'manwang',
   ]
   
   title = [
       '123',
       '321',
       '12',
       '21',
       'aaa',
       'bbb',
       'ccc',
       'sss',
       'aaaa',
       'cccc',
   ]
   
   client = MongoClient('127.0.0.1', 27017)
   db = client.test
   bbs = db.bbs
   bbs.drop()
   
   for i in range(1, 10000):
       na = name[randint(0, 9)]
       ti = title[randint(0, 9)]
       new_card = {'author': na, 'title': ti, }
       bbs.insert_one(new_card)
   
   print(bbs.count_documents({}))
   ```

   ![11-1.5-3-编写bbs代码.png](./pic/11-1.5-3-编写bbs代码.png)

3. 执行 Py 代码

   切换至 pybbs.py 所在目录下，执行以下命令

   ```sh
   python3 pybbs.py # 如果当前环境是 Python3 环境，则使用 python 关键字
   ```

   ![11-1.5-4-运行代码.png](./pic/11-1.5-4-运行代码.png)

4. 查看插入的数据

   （1）启动 mongo shell

   ```sh
   mongosh # 启动 mongo shell
   ```
   
   ![11-1.5-5-启动mongosh.png](./pic/11-1.5-5-启动mongosh.png)
   
   （2）查看数据格式，注意：数据是随机组合的，所以查询到的数据可能会不一样，这是正常现象
   
      ```js
      use test
      db.bbs.findOne({})
      ```
   
   ![11-1.5-6-查看数据格式.png](./pic/11-1.5-6-查看数据格式.png)

二、在 mongodb shell 终端查询

1. 查询每条记录的作者。

   ```js
   db.bbs.aggregate({ $project: { author: 1 } })
   ```

   ![11-1.5-7-查询1.png](./pic/11-1.5-7-查询1.png)

2. 用 group 将作者名称分组

   ```js
   db.bbs.aggregate({ $group: { _id: '$author', count: { $sum: 1 } } })
   ```

   ![11-1.5-7-查询2.png](./pic/11-1.5-7-查询2.png)

3. 在题目2的基础上进行排序

   ```js
   db.bbs.aggregate({ $group: { _id: '$author', count: { $sum: 1 } } }, { $sort: { count: -1 } })
   ```

   ![11-1.5-7-查询3.png](./pic/11-1.5-7-查询3.png)

4. 在题目3的基础上限制输出结果为5个

   ```js
   db.bbs.aggregate({ $group: { _id: '$author', count: { $sum: 1 } } }, { $sort: { count: -1 } }, { $limit: 5 })
   ```

   ![11-1.5-7-查询4.png](./pic/11-1.5-7-查询4.png)

### **实验总结**

该实验的主要内容是使用 Python 进行操作 MongoDB，进行数据插入，然后使用 mongo shell 进行对数据查询，涉及 find() 函数，聚合函数如：countDocuments，limit 以及 group 等的使用。

